/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.outconn;

import com.ibm.hwmca.base.saverest.CustomizableData;
import com.ibm.hwmca.base.saverest.DataRepApp;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.rcs.conndata.ConnectionInfoManager;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigEvent;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigListener;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConnectivityConstants;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OutboundConfigManager
implements OutboundConnectivityConstants {
    private static final String TRACE_MASKT = "XRCSOCMT";
    private static final String TRACE_MASKF = "XRCSOCMF";
    private static final String TRACE_MASKD = "XRCSOCMD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-ObCfgMgr");
    private static final String PERSISTENCE_NAME = "com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData";
    private static OutboundConfigManager outboundConfigMgr = null;
    private Object dataLock = new Object();
    private List listeners = new ArrayList();
    private Object listenersLock = new Object();

    private OutboundConfigManager() {
        Trace.trace(TRACE_MASKT, "<> OutboundConfigManager()");
    }

    public static synchronized OutboundConfigManager getOutboundConfigManager() {
        Trace.trace(TRACE_MASKT, "-> getOutboundConfigManager()");
        if (outboundConfigMgr == null) {
            outboundConfigMgr = new OutboundConfigManager();
        }
        Trace.trace(TRACE_MASKT, "<- getOutboundConfigManager()");
        return outboundConfigMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutboundConfigListener(OutboundConfigListener listener) {
        Trace.trace(TRACE_MASKT, "-> addOutboundConfigListener()");
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.add(listener);
        }
        Trace.trace(TRACE_MASKT, "<- addOutboundConfigListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutboundConfigListener(OutboundConfigListener listener) {
        Trace.trace(TRACE_MASKT, "-> removeOutboundConfigListener()");
        Object object = this.listenersLock;
        synchronized (object) {
            if (listener != null) {
                this.listeners.remove(listener);
            }
        }
        Trace.trace(TRACE_MASKT, "<- removeOutboundConfigListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutboundConfigData getOutboundConfig() {
        Trace.trace(TRACE_MASKT, "-> getOutboundConfig()");
        OutboundConfigData outboundConfigData = null;
        Object object = this.dataLock;
        synchronized (object) {
            PersistenceManager persMgr = PersistenceManager.getPersistenceManager();
            if (persMgr.contains(PERSISTENCE_NAME)) {
                try {
                    outboundConfigData = (OutboundConfigData)persMgr.read(PERSISTENCE_NAME);
                }
                catch (PersistenceException pe) {
                    Trace.trace(TRACE_MASKF, "PersistenceException: " + pe.getMessage());
                    new FrameworkLog(classLogInfo, 1938, pe).log();
                    outboundConfigData = new OutboundConfigData();
                }
            } else {
                outboundConfigData = new OutboundConfigData();
            }
        }
        Trace.trace(TRACE_MASKT, "<- getOutboundConfig()");
        return outboundConfigData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutboundConfig(OutboundConfigData data) {
        DataRepApp dataRepApp;
        Trace.trace(TRACE_MASKT, "-> setOutboundConfig()");
        Trace.trace(TRACE_MASKF, data.toString());
        boolean refreshConnInfo = false;
        boolean replicateData = false;
        Object object = this.dataLock;
        synchronized (object) {
            try {
                OutboundConfigData prevData = this.getOutboundConfig();
                PersistenceManager.getPersistenceManager().write(PERSISTENCE_NAME, data);
                Object object2 = this.listenersLock;
                synchronized (object2) {
                    if (this.listeners.size() > 0) {
                        OutboundConfigData dataCopy = this.getOutboundConfig();
                        OutboundConfigEvent event = new OutboundConfigEvent(this, 1, dataCopy);
                        Iterator iterator = this.listeners.iterator();
                        while (iterator.hasNext()) {
                            OutboundConfigListener listener = (OutboundConfigListener)iterator.next();
                            String className = listener.getClass().getName();
                            Trace.trace(TRACE_MASKF, "-> " + className + ".outboundConfigChanged()");
                            listener.outboundConfigChanged(event);
                            Trace.trace(TRACE_MASKF, "<- " + className + ".outboundConfigChanged()");
                        }
                    }
                }
                replicateData = true;
                if (data.isCallHomeServer() && data.isAllowDial() && !this.isPhoneInfoSame(prevData, data)) {
                    refreshConnInfo = true;
                }
            }
            catch (PersistenceException pe) {
                Trace.trace(TRACE_MASKF, "PersistenceException: " + pe.getMessage());
                new FrameworkLog(classLogInfo, 1938, pe).log();
            }
        }
        if (replicateData && (dataRepApp = DataRepApp.getDataRepApp()).isDataRepEnabled() && !dataRepApp.isUpdateInProgress()) {
            dataRepApp.updateCustomDataLevel(PERSISTENCE_NAME);
        }
        if (refreshConnInfo) {
            ConnectionInfoManager connInfoMgr = ConnectionInfoManager.getConnectionInfoManager();
            connInfoMgr.refreshUpdatableFiles(true);
        }
        Trace.trace(TRACE_MASKT, "<- setOutboundConfig()");
    }

    private boolean isPhoneInfoSame(OutboundConfigData copy1, OutboundConfigData copy2) {
        return copy1.getPhoneInfo().equals(copy2.getPhoneInfo());
    }

    public static class SaveRestore
    implements CustomizableData {
        public SaveRestore() {
            Trace.trace(OutboundConfigManager.TRACE_MASKT, "<> SaveRestore");
        }

        public UIInfo getUIInfo() {
            LocalizableText name = new LocalizableText("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnMsgs", "DATA_NAME");
            LocalizableText caption = new LocalizableText("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnMsgs", "DATA_CAPTION");
            return new UIInfo(name, caption);
        }

        public Serializable getSaveableData() {
            Trace.trace(OutboundConfigManager.TRACE_MASKT, "-> getSaveableData()");
            OutboundConfigManager cfgMgr = OutboundConfigManager.getOutboundConfigManager();
            OutboundConfigData outConfigData = cfgMgr.getOutboundConfig();
            Trace.trace(OutboundConfigManager.TRACE_MASKF, outConfigData.toString());
            Trace.trace(OutboundConfigManager.TRACE_MASKT, "<- getSaveableData()");
            return outConfigData.getPersistentData();
        }

        public void restoreData(Serializable obj) {
            Trace.trace(OutboundConfigManager.TRACE_MASKT, "-> restoreData()");
            try {
                PersistentData persistentData = (PersistentData)obj;
                OutboundConfigData outConfigData = new OutboundConfigData(persistentData);
                OutboundConfigManager cfgMgr = OutboundConfigManager.getOutboundConfigManager();
                cfgMgr.setOutboundConfig(outConfigData);
            }
            catch (Exception e) {
                // empty catch block
            }
            Trace.trace(OutboundConfigManager.TRACE_MASKT, "<- restoreData()");
        }

        public String getCustomDataKey() {
            return OutboundConfigManager.PERSISTENCE_NAME;
        }
    }
}

